# Troubleshooting

Use this playbook when Mnexium integration work fails at runtime.

## 401 or 403 Responses

Checks:
- confirm `x-mnexium-key` is present on outbound request
- confirm provider key header is present for chosen model/provider
- ensure secrets are loaded in the environment where request runs

Fix:
- rotate invalid keys and retry with a minimal request
- verify environment variable names match app code exactly

## 400 Validation Errors

Checks:
- ensure required request fields exist (`model`, input/messages, `mnx.subject_id`)
- ensure request shape matches the target endpoint contract
- validate `mnx` keys against `llms.txt` contract

Fix:
- log payload schema errors (redacted) and normalize to actionable app errors

## 429 or 5xx Spikes

Checks:
- inspect retry behavior and max attempts
- inspect latency and request burst patterns

Fix:
- apply bounded exponential backoff with jitter
- add circuit-break or short cooldown for sustained spikes

## Wrong User Context or Cross-User Data

Checks:
- verify subject mapping from authenticated user to `mnx.subject_id`
- confirm per-thread `chat_id` isolation

Fix:
- enforce auth checks before every history/memory/profile/state/claims/records read
- add tests for cross-user access denial

## Records Failures

Checks:
- schema exists for the record type before CRUD/query/search
- payload conforms to schema and auth scope
- route is one of the published records endpoints (not `/api/v1/records/events`)

Fix:
- create/update schema first, then replay entity requests

### Records Schema 400: `type_name_required`

Symptom:
- `POST /api/v1/records/schemas` returns `400` with payload error `type_name_required`

Cause:
- missing `type_name` in schema creation body

Fix:
- send at least:

```json
{
  "type_name": "tickets"
}
```

- verify with `GET /api/v1/records/schemas/tickets`
- then retry `POST /api/v1/records/tickets`

### Records 400: `data_required` (`data must be a JSON object`)

Symptom:
- `POST /api/v1/records/:type` or `PUT /api/v1/records/:type/:id` returns `400`
- error payload includes `data_required`

Cause:
- request body missing `data`, or `data` is not a JSON object
- common mistake: sending `record` instead of `data`

Fix:
- use:

```json
{
  "data": {
    "title": "Payment page error",
    "status": "open"
  }
}
```

- ensure the endpoint is:
  - create: `/api/v1/records/:type`
  - update: `/api/v1/records/:type/:id`
- avoid `/api/v1/records/events` unless explicitly documented in the active API contract

## Quick Minimal Probe

Use a minimal chat call to isolate auth/route issues before debugging app layers:
- endpoint: `POST /api/v1/chat/completions`
- include `x-mnexium-key`, provider key, one user message, and `mnx.subject_id`
