# Trigger Tests

Use these tests to validate that `mnexium-app-builder` triggers when it should and stays quiet when it should not.

Run at least 12 tests before publishing updates to this skill:
- 6 positive trigger tests
- 3 paraphrase trigger tests
- 3 negative trigger tests

## Positive Trigger Tests (should trigger)

1. "Build a Node API route that sends chat requests through Mnexium."
2. "Implement `mnx.subject_id` and stable `mnx.chat_id` for each conversation."
3. "Add memory recall to our assistant and make it configurable per request."
4. "Set up Mnexium records schemas and CRUD for a `tickets` type."
5. "Add retries and error normalization around Mnexium 429/5xx failures."
6. "Create integration tests for Mnexium chat continuity and history toggles."

## Paraphrase Tests (should trigger)

1. "Wire my app into Mnexium with production guardrails."
2. "Make this Mnexium integration reliable and observable."
3. "Help me structure claims, profiles, and state with Mnexium endpoints."

## Negative Trigger Tests (should not trigger)

1. "Design a better card layout and typography for this dashboard."
2. "Write a PostgreSQL migration for adding nullable columns."
3. "Summarize this meeting transcript and rewrite it in plain English."

## Pass Criteria

- Positive/paraphrase tests trigger consistently.
- Negative tests do not trigger.
- No repeated confusion with generic non-Mnexium coding requests.

## If Failing

- Under-triggering: broaden trigger phrases in frontmatter description with user-language wording.
- Over-triggering: add stricter negatives in frontmatter description and body `Should not trigger` list.
