# Production Checklist

Apply this checklist before marking Mnexium integration work complete.

## Security

- Mnexium and provider keys are server-side only.
- Logs redact secrets and sensitive user content.
- Subject-level authorization is enforced before reading/writing user data.

## Correctness

- Every request includes stable `mnx.subject_id`.
- Threaded conversations reuse `mnx.chat_id`.
- `mnx` flags (`history`, `learn`, `recall`, `summarize`) match product behavior.
- Retry policy handles `429` and `5xx` with bounded backoff.

## Feature Checks

- Chat continuity works across turns.
- Memory recall changes context only when enabled.
- Profiles update/read paths work for allowed users only.
- Agent state loads/saves/deletes by key correctly.
- Claims truth reads and slot-specific reads return expected values.
- Records schema, CRUD, query, and search flows work with access control.

## Observability

- Metrics include latency, status-code distribution, and recall usage.
- Failure logs include endpoint, status, request ID, and correlation IDs.
- Alerts are configured for elevated 5xx or sustained 429 rates.

## Release

- Required env vars are documented for all environments.
- Integration tests pass in CI.
- Rollout plan includes fallback/feature flags for memory and recall.

