# Endpoint Map

Use this map when selecting Mnexium APIs for app features.
Canonical details remain in `https://www.mnexium.com/llms.txt`.

## Chat + Responses

- `POST /api/v1/chat/completions`
- `POST /api/v1/responses`

Use for normal assistant interactions. Include the `mnx` object with at least `subject_id`; persist `chat_id` for multi-turn threads.

## Chat History

- `GET /api/v1/chat/history/list`
- `GET /api/v1/chat/history/read`
- `DELETE /api/v1/chat/history/delete`

Use for inbox/thread views, backfill, and chat management tools.

## Memories

- `GET /api/v1/memories`
- `GET /api/v1/memories/search`
- `POST /api/v1/memories`
- `GET/PATCH/DELETE /api/v1/memories/:id`
- `GET /api/v1/memories/superseded`
- `POST /api/v1/memories/:id/restore`
- `GET /api/v1/memories/recalls`

Use for long-term personalization and semantic retrieval.

## Claims + Truth Views

- `GET /api/v1/claims/:id`
- `GET /api/v1/claims/subject/:subject_id/truth`
- `GET /api/v1/claims/subject/:subject_id/slot/:slot`
- `GET /api/v1/claims/subject/:subject_id/slots`
- `GET /api/v1/claims/subject/:subject_id/graph`
- `GET /api/v1/claims/subject/:subject_id/history`
- `POST /api/v1/claims`
- `POST /api/v1/claims/:id/retract`

Use when current truth per slot matters (for example preference winners or latest profile facts).

## Profiles

- `GET /api/v1/profiles`
- `GET /api/v1/profiles/schema`
- `PATCH /api/v1/profiles`
- `DELETE /api/v1/profiles`

Use for structured user fields and app settings synced with Mnexium.

## Agent State

- `GET /api/v1/state/:key`
- `PUT /api/v1/state/:key`
- `DELETE /api/v1/state/:key`

Use for workflow checkpoints and resumable task state.

## Records

- `GET/POST /api/v1/records/schemas`
- `GET /api/v1/records/schemas/:type`
- `GET/POST /api/v1/records/:type`
- `GET/PUT/DELETE /api/v1/records/:type/:id`
- `POST /api/v1/records/:type/query`
- `POST /api/v1/records/:type/search`

Do not call unpublished variants such as `/api/v1/records/events`.
Use only the routes listed above unless the official contract changes.

Use for typed business entities with schema-backed CRUD and query/search.

### What Records Are

Records are structured objects grouped by `type` (for example `tickets`, `projects`, `contacts`, `orders`).
Think of them as application data models with:
- explicit schema definition
- typed fields
- managed CRUD endpoints
- filter query and semantic search support

### Recommended Records Flow

1. Define schema for a `type` using `/api/v1/records/schemas`.
2. Validate that schema via `/api/v1/records/schemas/:type`.
3. Create records with `POST /api/v1/records/:type`.
4. Read/update/delete with `GET/PUT/DELETE /api/v1/records/:type/:id`.
5. Use `/query` for deterministic filters and `/search` for semantic retrieval.

### Schema Creation Is Mandatory

If schema creation is skipped or malformed, record writes fail.
At minimum, `POST /api/v1/records/schemas` must include `type_name`.

Minimal schema create request:

```json
{
  "type_name": "tickets"
}
```

Expanded schema create request (shape may vary by deployment):

```json
{
  "type_name": "tickets",
  "schema": {
    "fields": {
      "title": { "type": "string" },
      "status": { "type": "string" },
      "priority": { "type": "string" }
    }
  }
}
```

Validation sequence:
1. `POST /api/v1/records/schemas` with `type_name`
2. `GET /api/v1/records/schemas/tickets` to confirm registration
3. only then call `POST /api/v1/records/tickets`

### Example Records Request (with mnx)

```json
{
  "subject_id": "user_123",
  "data": {
    "title": "Payment page error",
    "status": "open",
    "priority": "high",
    "channel": "web"
  },
  "mnx": {
    "subject_id": "user_123",
    "chat_id": "chat_456",
    "history": false,
    "learn": false,
    "recall": false
  }
}
```

Example usage:
- endpoint: `POST /api/v1/records/tickets`
- `data` holds the typed business entity payload (required JSON object)
- `mnx` carries request context (subject/thread/memory flags) when your app passes Mnexium context through the same workflow
- keep `mnx.subject_id` aligned with top-level `subject_id` to avoid cross-user mistakes

### Required Request Shapes (Records CRUD)

Create record (`POST /api/v1/records/:type`):

```json
{
  "data": {
    "title": "Payment page error",
    "status": "open"
  }
}
```

Update record (`PUT /api/v1/records/:type/:id`):

```json
{
  "data": {
    "status": "resolved"
  }
}
```

If `data` is missing or not an object, API returns:
- `400`
- `error: "data_required"`
- `message: "data must be a JSON object"`

### Advanced Chat + Records Context Example

Use this pattern when a chat request should also carry record-context instructions.
Validate available `mnx` keys against `https://www.mnexium.com/llms.txt` for your deployment.

```json
{
  "model": "gpt-4.1-mini",
  "messages": [
    {
      "role": "user",
      "content": "Create a support ticket for the payment page error"
    }
  ],
  "mnx": {
    "subject_id": "user_123",
    "chat_id": "chat_456",
    "history": true,
    "learn": true,
    "recall": true,
    "state": {
      "load": true,
      "save": true
    },
    "records": {
      "recall": true,
      "learn": "auto",
      "sync": false,
      "tables": ["tickets", "accounts"]
    },
    "metadata": {}
  }
}
```

### Example Types and Intent

- `tickets`: support issues, status, priority, assignee
- `projects`: project metadata, owners, milestones
- `contacts`: customer profile entities for support/sales workflows

### Query vs Search

- `/query`: exact filters and structured constraints
- `/search`: semantic matching over record content

Use both in production apps:
- start with `/query` when exact constraints are known
- add `/search` for intent-based discovery and fuzzy recall
